/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_state_machine.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Codes
 ******************************************************************************/

static uint32_t FLEXIO_SSI_GetInstance(FLEXIO_STATEMACHINE_Type *base)
{
    return FLEXIO_GetInstance(base->flexioBase);
}

void FLEXIO_StateMachine_Init(FLEXIO_STATEMACHINE_Type *base, flexio_statemachine_config_t *FlexioConfig)
{
    assert(base);
    assert(FlexioConfig);

    flexio_shifter_config_t shifterConfig;
    flexio_timer_config_t timerConfig;
    uint32_t ctrlReg  = 0;

    /* Clear the shifterConfig & timerConfig struct. */
    memset(&shifterConfig, 0, sizeof(shifterConfig));
    memset(&timerConfig, 0, sizeof(timerConfig));

#if !(defined(FSL_SDK_DISABLE_DRIVER_CLOCK_CONTROL) && FSL_SDK_DISABLE_DRIVER_CLOCK_CONTROL)
    /* Ungate flexio clock. */
    CLOCK_EnableClock(s_flexioClocks[FLEXIO_SSI_GetInstance(base)]);
#endif /* FSL_SDK_DISABLE_DRIVER_CLOCK_CONTROL */

    ctrlReg = base->flexioBase->CTRL;
    ctrlReg &= ~(FLEXIO_CTRL_DOZEN_MASK | FLEXIO_CTRL_DBGE_MASK | FLEXIO_CTRL_FASTACC_MASK | FLEXIO_CTRL_FLEXEN_MASK);
    ctrlReg |= (FLEXIO_CTRL_DBGE(FlexioConfig->enableInDebug) | FLEXIO_CTRL_FASTACC(FlexioConfig->enableFastAccess) |
                FLEXIO_CTRL_FLEXEN(FlexioConfig->enableFlexIO));
//    if (!FlexioConfig->enableInDoze)
//    {
//        ctrlReg |= FLEXIO_CTRL_DOZEN_MASK;
//    }
//
//    FLEXIO_CTRL_DOZEN(1);
      
    base->flexioBase->CTRL = ctrlReg;

    /* Do hardware configuration. */
    /* 1. Configure the shifter 0 . */
    shifterConfig.timerSelect = base->timerIndex[0];
    shifterConfig.pinConfig   = kFLEXIO_PinConfigOutput;
    shifterConfig.pinSelect   = base->InputPinIndex;
    shifterConfig.pinPolarity = kFLEXIO_PinActiveHigh;
    shifterConfig.shifterMode = kFLEXIO_ShifterModeState;
    shifterConfig.inputSource = kFLEXIO_ShifterInputFromPin;
    shifterConfig.timerPolarity = kFLEXIO_ShifterTimerPolarityOnNegitive;
    shifterConfig.parallelWidth = 0xF;
    shifterConfig.shifterStop   = 0x2;
    shifterConfig.shifterStart  = 0x0;

    FLEXIO_SetShifterConfig(base->flexioBase, base->shifterIndex[0], &shifterConfig);
    base->flexioBase->SHIFTBUF[0] = 0x00208208;
    
    /* 2. Configure the shifter 1 . */
    shifterConfig.timerSelect  = base->timerIndex[0];
    shifterConfig.pinConfig    = kFLEXIO_PinConfigOutput;
    shifterConfig.pinSelect    = base->InputPinIndex;
    shifterConfig.pinPolarity  = kFLEXIO_PinActiveHigh;
    shifterConfig.shifterMode  = kFLEXIO_ShifterModeState;
    shifterConfig.inputSource  = kFLEXIO_ShifterInputFromPin;
    shifterConfig.timerPolarity = kFLEXIO_ShifterTimerPolarityOnPositive;
    shifterConfig.parallelWidth = 0xF;
    shifterConfig.shifterStop   = 0x2;
    shifterConfig.shifterStart  = 0x0;
   
    FLEXIO_SetShifterConfig(base->flexioBase, base->shifterIndex[1], &shifterConfig);
    base->flexioBase->SHIFTBUF[1] = 0x02408408;
    
    /* 3. Configure the shifter 2 . */
    shifterConfig.timerSelect  = base->timerIndex[0];
    shifterConfig.pinConfig    = kFLEXIO_PinConfigOutput;
    shifterConfig.pinSelect    = base->InputPinIndex;
    shifterConfig.pinPolarity  = kFLEXIO_PinActiveHigh;
    shifterConfig.shifterMode  = kFLEXIO_ShifterModeState;
    shifterConfig.inputSource  = kFLEXIO_ShifterInputFromPin;
    shifterConfig.timerPolarity = kFLEXIO_ShifterTimerPolarityOnNegitive;
    shifterConfig.parallelWidth = 0xF;
    shifterConfig.shifterStop   = 0x2;
    shifterConfig.shifterStart  = 0x0;
   
    FLEXIO_SetShifterConfig(base->flexioBase, base->shifterIndex[2], &shifterConfig);
    base->flexioBase->SHIFTBUF[2] = 0x06249249;
  
    /* 5. Configure the timer 0 . */
    timerConfig.timerMode       = kFLEXIO_TimerModeSingle16Bit;
    timerConfig.timerOutput     = kFLEXIO_TimerOutputOneNotAffectedByReset;
    timerConfig.timerDecrement  = kFLEXIO_TimerDecSrcOnFlexIOClockShiftTimerOutput;
    timerConfig.timerReset      = kFLEXIO_TimerResetNever;
    timerConfig.timerDisable    = kFLEXIO_TimerDisableNever;
    timerConfig.timerEnable     = kFLEXIO_TimerEnabledAlways;
    timerConfig.timerStop       = kFLEXIO_TimerStopBitDisabled;
    timerConfig.timerStart      = kFLEXIO_TimerStartBitDisabled;
    timerConfig.timerCompare = 6000-1;
    FLEXIO_SetTimerConfig(base->flexioBase, base->timerIndex[0], &timerConfig); 
}


void FLEXIO_StateMachine_InitGetDefaultConfig(flexio_statemachine_config_t *FlexioConfig)
{
    assert(FlexioConfig);

    /* Initializes the configure structure to zero. */
    memset(FlexioConfig, 0, sizeof(*FlexioConfig));

    FlexioConfig->enableFlexIO     = true;
    FlexioConfig->enableInDoze     = false;
    FlexioConfig->enableInDebug    = true;
    FlexioConfig->enableFastAccess = false;
}













